import type { NextApiRequest, NextApiResponse } from 'next';
import { prisma } from '@/lib/prisma';

export default async function handler(
    req: NextApiRequest,
    res: NextApiResponse
) {
    if (req.method === 'GET') {
        try {
            const clients = await prisma.client.findMany({
                orderBy: { createdAt: 'desc' },
            });
            return res.status(200).json(clients);
        } catch (error) {
            return res.status(500).json({ error: 'Failed to fetch clients' });
        }
    } else if (req.method === 'POST') {
        const { name, openaiApiKey, workflowId } = req.body;
        try {
            const client = await prisma.client.create({
                data: {
                    name,
                    openaiApiKey,
                    workflowId,
                },
            });
            return res.status(201).json(client);
        } catch (error) {
            return res.status(500).json({ error: 'Failed to create client' });
        }
    } else {
        res.setHeader('Allow', ['GET', 'POST']);
        res.status(405).end(`Method ${req.method} Not Allowed`);
    }
}
